classdef SuhDemo < handle
%   AUTHORSHIP
%   Primary Developer: Stephen Meehan <swmeehan@stanford.edu> 
%   Copyright (c) 2022 The Board of Trustees of the Leland Stanford Junior University; Herzenberg Lab
%   License: BSD 3 clause

methods(Static)
    function r=FindResources(file)
        r={};
        file=upper(file);
        if startsWith(file, 'OMIP-047') || startsWith(file, 'OMIP 47') ...
                || startsWith(file, 'OMIP47') || startsWith(file, 'OMIP047')
            r={'DataSource', 'OMIP-047', 'Publication', ...
                'https://onlinelibrary.wiley.com/doi/full/10.1002/cyto.a.23488',...
                'Gating chart', ...
                'https://docs.google.com/document/d/10Zr3H0itTzrLpy7_kle8Vks1Sj_J0iIowQ9AAzT5He8/edit?usp=sharing'};
        elseif startsWith(file, 'OMIP-044') || startsWith(file, 'OMIP 44')...
                || startsWith(file, 'OMIP44') || startsWith(file, 'OMIP044')
            r={'DataSource', 'OMIP-044', 'Publication', ...
                'https://onlinelibrary.wiley.com/doi/10.1002/cyto.a.23331',...
                'Gating chart', ...
                'https://docs.google.com/document/d/1y5q9p1XrmZCr2CAQvHacE7KQlXyWm66y3JvmiYRtq0M/edit?usp=sharing'};
        elseif startsWith(file, 'GENENTECH') || startsWith(file, 'ESHGHI')
            r={'DataSource', 'GENENTECH', 'Publication', ...
                'https://www.frontiersin.org/articles/10.3389/fimmu.2019.01194/full', ...
                'Gating chart', 'https://docs.google.com/document/d/1BaIs0D6JGGSoYCpZ7UiglMW3QozEMRTU5ShCGAm_5tg/edit?usp=sharing', ...
                'Tutorial', ' https://docs.google.com/document/d/1Py-SNo32f6Js_MuMNsSndd2xzsSSZGW_gCeRVp0p5z0/edit?usp=sharing'};
        elseif startsWith(file, 'OMIP-077') || startsWith(file, 'OMIP 77') ...
                || startsWith(file, 'OMIP77') || startsWith(file, 'OMIP077')
            r={'DataSource', 'OMIP-077', ...
                'Publication', 'https://doi.org/10.1002/cyto.a.24481',...
                'Gating chart', ...
                ['https://docs.google.com/document/d/' ...
                '12qK3JikpDMxfrTfxjDZs5iy8b_yM-8-dEDy83smRrSI' ...
                '/edit?usp=sharing']};
        elseif startsWith(file, 'GHOSN') || startsWith(file, 'ELIVER')
            r={'DataSource', 'GHOSN', 'Publication', ...
                'https://www.pnas.org/content/107/6/2568', ...
                'Gating chart', ...
                'https://docs.google.com/document/d/1GmbrAyxp4Gq0W2D8eYAoG6vls1kmu2wTpTzY-K16vPA/edit?usp=sharing'};
        elseif startsWith(file, 'OMIP-069') || startsWith(file, 'OMIP 69')...
                || startsWith(file, 'OMIP69') || startsWith(file, 'OMIP069')
            r={'DataSource', 'OMIP-069', 'Publication', ...
                'https://onlinelibrary.wiley.com/doi/full/10.1002/cyto.a.24213',...
                'Gating chart', 'https://docs.google.com/document/d/1CSPMEt4pfYyIvsp_P4_RgJrQ3SKLGpXGHwBYnwhyQgk/edit?usp=sharing'};    
        elseif startsWith(file, 'OMIP-058') || startsWith(file, 'OMIP 58')...
                || startsWith(file, 'OMIP58') || startsWith(file, 'OMIP058')
            r={'DataSource', 'OMIP-058',...
                'Publication', 'https://doi.org/10.1002/cyto.a.23850',...
                'Gating chart', ...
                'https://docs.google.com/document/d/1aufVvy8GhAIyWJGMtFAMICbcwKi7ubxgv_Y6J_nPBPQ/edit?usp=sharing'};
        elseif startsWith(file, 'LEIPOLD') || startsWith(file, 'HOLDEN') || startsWith(file, 'LEIPOLD') 
             r={'DataSource', 'LEIPOLD', 'Publication',...
                'https://www.sciencedirect.com/science/article/pii/S0022175917304908?via%3Dihub', ...
                'Gating chart', 'https://docs.google.com/document/d/1jUqSvzKPsBttLZvqnP8tDmGxnzAg2yMv7Db6qXkSe4o/edit?usp=sharing'};
        elseif startsWith(file, 'PANORAMA') || startsWith(file, 'NIKOLAY') || startsWith(file, 'SAMUSIK') 
             r={...
                'DataSource', 'PANORAMA', 'Publication', ...
                'https://www.nature.com/articles/nmeth.3863?WT.feed_name=subjects_haematopoiesis',...
                'Gating chart', ...
                'https://docs.google.com/document/d/14r-Z_4HHIb-sogo5GU1S5uAA9KSOr7UHeysSXnCIPCQ/edit?usp=sharing'...
                };
        end
    end

    function gt=Omip47_wayne
            gt=FlowJoTree.NewOrReuse(...
                'https://storage.googleapis.com/cytogenie.org/Samples/omipB/omip47_swm.wsp',...
                {'Publication', ...
                'https://onlinelibrary.wiley.com/doi/full/10.1002/cyto.a.23488',...
                'Gating chart', ...
                'https://docs.google.com/document/d/10Zr3H0itTzrLpy7_kle8Vks1Sj_J0iIowQ9AAzT5He8/edit?usp=sharing'});
        end

        function gt=Omip58
            gt=FlowJoTree.NewOrReuse(...
                ['https://storage.googleapis.com/cytogenie.org/' ...
                'Samples/OMIP-058/OMIP-058.wsp'],...
                {'DataSource', 'OMIP-058', 'Publication', 'https://doi.org/10.1002/cyto.a.23850',...
                'Gating chart', ...
                'https://docs.google.com/document/d/1aufVvy8GhAIyWJGMtFAMICbcwKi7ubxgv_Y6J_nPBPQ/edit?usp=sharing'});
        end

        function gt=Omip77
            gt=FlowJoTree.NewOrReuse(...
                ['https://storage.googleapis.com/cytogenie.org/' ...
                'Samples/OMIP-077/OMIP-077-3WAM.wsp'],...
                {'DataSource', 'OMIP-077', 'Publication', 'https://doi.org/10.1002/cyto.a.24481',...
                'Gating chart', ...
                ['https://docs.google.com/document/d/' ...
                '12qK3JikpDMxfrTfxjDZs5iy8b_yM-8-dEDy83smRrSI' ...
                '/edit?usp=sharing']});
        end

        function gt=Omip47
            gt=FlowJoTree.NewOrReuse(...
                'https://storage.googleapis.com/cytogenie.org/Samples/omipB/omip047_B_cells.wsp',...
                {'DataSource', 'OMIP-047', 'Publication', ...
                'https://onlinelibrary.wiley.com/doi/full/10.1002/cyto.a.23488',...
                'Gating chart', ...
                'https://docs.google.com/document/d/10Zr3H0itTzrLpy7_kle8Vks1Sj_J0iIowQ9AAzT5He8/edit?usp=sharing'});
        end

        function gt=Omip47Older
            gt=FlowJoTree.NewOrReuse(...
                'https://storage.googleapis.com/cytogenie.org/Samples/omipB/omip47_B_cells.wsp',...
                {'Publication', ...
                'https://onlinelibrary.wiley.com/doi/full/10.1002/cyto.a.23488',...
                'Gating chart', ...
                'https://docs.google.com/document/d/10Zr3H0itTzrLpy7_kle8Vks1Sj_J0iIowQ9AAzT5He8/edit?usp=sharing'});
        end

        function gt=Omip47Old
            gt=FlowJoTree.NewOrReuse(...
                'https://storage.googleapis.com/cytogenie.org/Samples/omipB/omip47.wsp',...
                {'Publication', ...
                'https://onlinelibrary.wiley.com/doi/full/10.1002/cyto.a.23488',...
                'Gating chart', ...
                'https://storage.googleapis.com/cytogenie.org/Tutorials/omipB.png'});
        end

        function gt=Omip47overlapped
            gt=FlowJoTree.NewOrReuse(...
                'https://storage.googleapis.com/cytogenie.org/Samples/omipB/omip47overlapped.wsp',...
                {'Publication', ...
                'https://onlinelibrary.wiley.com/doi/full/10.1002/cyto.a.23488',...
                'Gating chart', ...
                'https://storage.googleapis.com/cytogenie.org/Tutorials/omipB.png'});
        end

        function gt=Omip47Epp
            gt=FlowJoTree.NewOrReuse(...
                'https://storage.googleapis.com/cytogenie.org/Samples/omipB/omip47_EPP.wsp',...
                {'Publication', ...
                'https://onlinelibrary.wiley.com/doi/full/10.1002/cyto.a.23488',...
                'Gating chart', ...
                'https://storage.googleapis.com/cytogenie.org/Tutorials/omipB.png'});
        end

        function gt=Omip47Oldest
            gt=FlowJoTree.NewOrReuse(...
                'https://storage.googleapis.com/cytogenie.org/Samples/omipB/OMIP47_Bcells.wsp',...
                {'Publication', ...
                'https://onlinelibrary.wiley.com/doi/full/10.1002/cyto.a.23488',...
                'Gating chart', ...
                'https://storage.googleapis.com/cytogenie.org/Tutorials/omipB.png'});
        end
        
        function gt=Omip69
            gt=FlowJoTree.NewOrReuse(...
                'https://storage.googleapis.com/cytogenie.org/Samples/OMIP40Color/OMIP-069_v2.wsp',...
                {'DataSource', 'OMIP-069', 'Publication', ...
                'https://onlinelibrary.wiley.com/doi/full/10.1002/cyto.a.24213',...
                'Gating chart', 'https://docs.google.com/document/d/1CSPMEt4pfYyIvsp_P4_RgJrQ3SKLGpXGHwBYnwhyQgk/edit?usp=sharing'});
        end

        function gt=Omip69Old
            gt=FlowJoTree.NewOrReuse(...
                'https://storage.googleapis.com/cytogenie.org/Samples/OMIP40Color/omip69.wsp',...
                {'Publication', ...
                'https://onlinelibrary.wiley.com/doi/full/10.1002/cyto.a.24213',...
                'Gating chart', 'https://storage.googleapis.com/cytogenie.org/Tutorials/OMIP69.jpg'});
        end

        function uri=UriEliverOld
            uri='https://storage.googleapis.com/cytogenie.org/GetDown2/domains/FACS/demo/bCellMacrophageDiscovery/eliver3.wsp';
        end
        
        function uri=UriEliver
            uri='https://storage.googleapis.com/cytogenie.org/GetDown2/domains/FACS/demo/bCellMacrophageDiscovery/ghosnMacrophagesBCells.wsp';
        end

        function gt=Eliver
            gt=FlowJoTree.NewOrReuse(SuhDemo.UriEliver, ...
                {'DataSource', 'GHOSN', 'Publication', ...
                'https://www.pnas.org/content/107/6/2568', ...
                'Gating chart', ...
                'https://docs.google.com/document/d/1GmbrAyxp4Gq0W2D8eYAoG6vls1kmu2wTpTzY-K16vPA/edit?usp=sharing'});
        end
         
        function uri=UriUmap
            uri='https://storage.googleapis.com/cytogenie.org/GetDown2/domains/FACS/demo/bCellMacrophageDiscovery/demoEliver2.wsp';
        end
        
        function gt=Umap
            gt=FlowJoTree.NewOrReuse(SuhDemo.UriUmap, {'Publication', ...
                'https://www.pnas.org/content/107/6/2568', ...
                'Gating chart', ...
                'https://storage.googleapis.com/cytogenie.org/Tutorials/Ghosn1.jpg'});
        end
        
        function gt=Omip44
            gml=['https://storage.googleapis.com/cytogenie.org/' ...
                'Samples/omip44/omip044.wsp'];
            gt=FlowJoTree.NewOrReuse(gml, ...
                {'DataSource', 'OMIP-044', 'Publication', ...
                'https://onlinelibrary.wiley.com/doi/10.1002/cyto.a.23331',...
                'Gating chart', ...
                'https://docs.google.com/document/d/1y5q9p1XrmZCr2CAQvHacE7KQlXyWm66y3JvmiYRtq0M/edit?usp=sharing'});
        end
        
        
        function gt=Omip44Old
            gml=['https://storage.googleapis.com/cytogenie.org/' ...
                'Samples/omip44/omip44swm.wsp'];
            gt=FlowJoTree.NewOrReuse(gml, {'Publication', ...
                'https://onlinelibrary.wiley.com/doi/10.1002/cyto.a.23331',...
                'Gating chart', ...
                ['https://storage.googleapis.com/' ...
                'cytogenie.org/Tutorials/omip44.png'],...
                'Tutorial',['https://docs.google.com/document/d/' ...
                '1vZU-D_V8H_6eH2k8WdDLg1FVjMTHNUTzDIvq-yjvs0s/' ...
                'edit?usp=sharing']});
        end
        
        function gt=Omip44Epp
            gml='https://storage.googleapis.com/cytogenie.org/Samples/omip44/omip44_EPP.wsp';
            gt=FlowJoTree.NewOrReuse(gml, {'Publication', ...
                'https://onlinelibrary.wiley.com/doi/10.1002/cyto.a.23331',...
                'Gating chart', ...
                ['https://storage.googleapis.com/' ...
                'cytogenie.org/Tutorials/omip44.png']});
        end
        
        function uri=UriGenentech
            %uri='https://storage.googleapis.com/cytogenie.org/Samples/genentech/Genentech3.wsp';
            uri='https://storage.googleapis.com/cytogenie.org/Samples/genentech/Genentech10Merged.wsp';
        end
        
        function gt=Genentech(ask)
            uri=SuhDemo.UriGenentech;
            if nargin>0 && ask
                html=Html.WrapHr([
                    'Which samples from  the<br>' ...
                    'publication data set?']);
                opts={'One merged (500,00 events)', ...
                    'All 10 unmerged (~200,000 events each)'};
                choice=Gui.Ask(html, opts, 'GenentechDemo10', 'Confirm', 1);
                if isempty(choice)
                    gt=[];
                    return;
                end
                if choice>1
                    uri=SuhDemo.UriGenentech10Samples;
                end
            end
            gt=FlowJoTree.NewOrReuse(uri, ...
                {'DataSource', 'GENENTECH', 'Publication', ...
                'https://www.frontiersin.org/articles/10.3389/fimmu.2019.01194/full', ...
                'Gating chart', 'https://docs.google.com/document/d/1BaIs0D6JGGSoYCpZ7UiglMW3QozEMRTU5ShCGAm_5tg/edit?usp=sharing', ...
                'Tutorial', ' https://docs.google.com/document/d/1Py-SNo32f6Js_MuMNsSndd2xzsSSZGW_gCeRVp0p5z0/edit?usp=sharing'});

        end
        
        function uri=UriGenentech10Samples
            uri='https://storage.googleapis.com/cytogenie.org/Samples/genentech/Genentech10Unmerged.wsp';
        end
        
        function gt=Genentech10Samples
            gt=FlowJoTree.NewOrReuse(SuhDemo.UriGenentech10Samples, ...
                {'Publication', ...
                'https://www.frontiersin.org/articles/10.3389/fimmu.2019.01194/full', ...
                'Gating chart', 'https://docs.google.com/document/d/1BaIs0D6JGGSoYCpZ7UiglMW3QozEMRTU5ShCGAm_5tg/edit?usp=sharing'});
        end
        
        function uri=UriPanoramaOld
            uri='https://storage.googleapis.com/cytogenie.org/Samples/Nikolay/CyTOF_Panorama2.wsp';
        end
        
        function uri=UriPanorama
            uri='https://storage.googleapis.com/cytogenie.org/Samples/Nikolay/PANORAMA_v3.wsp';
        end
        
        function gt=Panorama
            gt=FlowJoTree.NewOrReuse(SuhDemo.UriPanorama, {...
                'DataSource', 'PANORAMA', 'Publication', ...
                'https://www.nature.com/articles/nmeth.3863?WT.feed_name=subjects_haematopoiesis',...
                'Gating chart', ...
                'https://docs.google.com/document/d/14r-Z_4HHIb-sogo5GU1S5uAA9KSOr7UHeysSXnCIPCQ/edit?usp=sharing'...
                });
            
        end
        
        function uri=UriMaecker
            uri='https://storage.googleapis.com/cytogenie.org/Samples/maecker/LEIPOLD.wsp';
        end

        function uri=UriMaeckerOld
            uri='https://storage.googleapis.com/cytogenie.org/Samples/maecker/leipoldComparisonCyTOF_v2.wsp';
        end

        function uri=UriMaeckerOlder
            uri='https://storage.googleapis.com/cytogenie.org/Samples/maecker/Maecker2.wsp';
        end
        
        
        function gt=Maecker
            gt=FlowJoTree.NewOrReuse(SuhDemo.UriMaecker, ...
                {'DataSource', 'LEIPOLD', 'Publication',...
                'https://www.sciencedirect.com/science/article/pii/S0022175917304908?via%3Dihub', ...
                'Gating chart', 'https://docs.google.com/document/d/1jUqSvzKPsBttLZvqnP8tDmGxnzAg2yMv7Db6qXkSe4o/edit?usp=sharing'});
        end

        function uri=UriDylan
            uri='https://storage.googleapis.com/cytogenie.org/Samples/demoForDylan.wsp';
        end

        function gt=Dylan
            gt=FlowJoTree.NewOrReuse(SuhDemo.UriDylan);
        end
        
        function btn=GetButton(callback, ...
                txt, icon, tip, closeParentWindow)
            if nargin<5
                closeParentWindow=true;
                if nargin<4
                    tip='Play with an example FlowJo workspace...';
                    if nargin<3
                        icon='demoIcon.gif';
                        if nargin<2
                            txt='Demos';
                        end
                    end
                end
            end
            btn=Gui.NewBtn(txt, @(h,e)ask(h), tip, icon);

            function ask(h)
                jw=Gui.WindowAncestor(h);
                    
                opts=cell(1,9);
                opts{7}=['<html>Macrophages & B cells<br>'...
                    '&nbsp;&nbsp;<i>from Eliver Ghosn et al</i></html>'];
                opts{6}=['<html>CyTOF Quantitative Comparison<br>'...
                    '&nbsp;&nbsp;<i>from S Toghi Eshghi et al</i></html>'];
                opts{4}=['<html>OMIP-069 40 color<br>'...
                    '&nbsp;&nbsp;<i>from Lily Park et al</i></html>'];
                opts{2}=['<html>OMIP-047 B cells<br>'...
                    '&nbsp;&nbsp;<i>from Thomas Liechti et al</i></html>'];
                opts{1}=['<html>OMIP-044 28 color<br>'...
                    '&nbsp;&nbsp;<i>from Florian Mair et al</i></html>'];
                opts{8}=['<html>CyTOF Comparison across sites<br>'...
                    '&nbsp;&nbsp;<i>from Michael Leipold et al</i></html>'];
                opts{9}=['<html>CyTOF Panorama<br>'...
                    '&nbsp;&nbsp;<i>from Nikolay Samusik et al</i></html>'];
                opts{3}=['<html>OMIP-058<br>'...
                    '&nbsp;&nbsp;<i>from Thomas Liechti et al</i></html>'];
                opts{5}=['<html>OMIP-077<br>'...
                    '&nbsp;&nbsp;<i>from Maximilian Boesch et al</i></html>'];
                idx=mnuMultiDlg(struct('javaWindow', jw, ...
                    'properties', BasicMap.Global, ...
                    'property', 'FlowJoBridge.Demos.Idx', ...
                    'msg', Html.WrapHr([...
                    'Explore one of our example<br>'...
                    'workspaces built with FlowJo 10.9.0'])), ...
                    'FlowJoBridge Demos', opts, 1, true, ...
                    true, [], [], [], [], 10, 'south east');
                if isempty(idx)
                    return;
                end
                if closeParentWindow
                    if ~isempty(jw)
                        jw.dispose
                    end
                end
                switch(idx) 
                    case 7
                        SuhDemo.Eliver;
                    case 6
                        SuhDemo.Genentech(true);
                    case 4
                        SuhDemo.Omip69;
                    case 2
                        SuhDemo.Omip47;
                    case 1
                        SuhDemo.Omip44;
                    case 9
                        SuhDemo.Panorama;
                    case 8
                        SuhDemo.Maecker
                    case 3
                        SuhDemo.Omip58
                    case 5
                        SuhDemo.Omip77
                end
                if ~isempty(callback)
                    feval(callback, idx, opts{idx});
                end
            end
        end       
end
end
